<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section4
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                   
#  Last update : 29/09/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="ted:PROCEDURE[child::*]" mode="R500R501">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F21' and @FORM!='F22']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R500'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PER_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R501'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:PROCEDURE/*[matches(local-name(),'^PT_')]" mode="R502R503R504R505">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM='F01']//ted:NOTICE[@*='PRI_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R502'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM='F04']//ted:NOTICE[@*='PER_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R503'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM='F23']//ted:NOTICE[@*='PRI']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R502'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'REDUCING_TIME_LIMITS')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R504'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'QSU')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R505'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22'][.//ted:NOTICE/@*!='AWARD_CONTRACT']//ted:PT_AWARD_CONTRACT_WITHOUT_CALL" mode="R506">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R506'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F15']" mode="R507">
		<xsl:choose>
			<xsl:when test=".//ted:DIRECTIVE/@*='2014/23/EU' and .//ted:PROCEDURE/ted:DIRECTIVE_2014_23_EU"/>
			<xsl:when test=".//ted:DIRECTIVE/@*='2014/24/EU' and .//ted:PROCEDURE/ted:DIRECTIVE_2014_24_EU"/>
			<xsl:when test=".//ted:DIRECTIVE/@*='2014/25/EU' and .//ted:PROCEDURE/ted:DIRECTIVE_2014_25_EU"/>
			<xsl:when test=".//ted:DIRECTIVE/@*='2009/81/EC' and .//ted:PROCEDURE/ted:DIRECTIVE_2009_81_EC"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('DIRECTIVE/@VALUE=', .//ted:DIRECTIVE/@*,' and PROCEDURE/',local-name(.//ted:PROCEDURE/*[matches(local-name(.),'DIRECTIVE_')]))"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R507'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04'][not(.//*[matches(local-name(),'^PT_')])]//ted:NOTICE/@*[matches(.,'CALL_COMPETITION')]" mode="R508">
		<xsl:variable name="ss_ele">
			<xsl:choose>
				<xsl:when test="ancestor::*[@FORM='F04']">missing {PT_RESTRICTED, PT_NEGOTIATED_WITH_PRIOR_CALL}</xsl:when>
				<xsl:otherwise>missing {PT_RESTRICTED, PT_COMPETITIVE_NEGOTIATION}</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',.,' and ',$ss_ele)"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R508'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][not(.//*[matches(local-name(),'^PT_')])]//ted:NOTICE[@*='CONCESSION_AWARD_CONTRACT']" mode="R509">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',@*,' and missing {PT_AWARD_CONTRACT_WITH_PRIOR_PUBLICATION, PT_AWARD_CONTRACT_WITHOUT_PUBLICATION}')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R509'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:FRAMEWORK|ted:DPS" mode="R510R511">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F01' and @FORM!='F04']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*!='PRI_ONLY' and @*!='PER_ONLY']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R510'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PER_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R511'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][not(.//ted:PT_RESTRICTED) and .//ted:DPS]" mode="R512">
		<xsl:choose>
			<xsl:when test="@FORM!='F01' and @FORM!='F02' and @FORM!='F04' and @FORM!='F05'"/>
			<xsl:when test=".//*[matches(local-name(),'^PT_')]">
				<xsl:variable name="ele" select="concat(local-name(.//*[matches(local-name(),'^PT_')]),' and DPS')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R512'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'DPS'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R512'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][not(.//ted:CENTRAL_PURCHASING) and .//ted:DPS_ADDITIONAL_PURCHASERS]" mode="R513">
		<xsl:variable name="ele" select="'DPS_ADDITIONAL_PURCHASERS'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R513'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][not(.//ted:PT_RESTRICTED) and .//ted:DPS]" mode="R514">
		<xsl:choose>
			<xsl:when test="@FORM!='F03' and @FORM!='F06'"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat(local-name(.//*[matches(local-name(),'^PT_')]),' and DPS')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R514'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22'][.//ted:NOTICE/@*='AWARD_CONTRACT']//ted:FRAMEWORK/ted:JUSTIFICATION" mode="R515">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and FRAMEWORK/JUSTIFICATION')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R515'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][.//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']]//ted:FRAMEWORK/ted:JUSTIFICATION" mode="R516">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and FRAMEWORK/JUSTIFICATION')"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R516'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05'][(.//ted:PT_RESTRICTED| .//ted:PT_OPEN) and .//ted:REDUCTION_RECOURSE]" mode="R517R518">
		<xsl:variable name="ele" select="concat(local-name(.//*[matches(local-name(),'^PT_')]),' and REDUCTION_RECOURSE')"/>
		<xsl:choose>
			<xsl:when test=".//ted:PT_OPEN">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R517'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:PT_RESTRICTED">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R518'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02'][not(.//ted:PT_COMPETITIVE_NEGOTIATION) and .//ted:RIGHT_CONTRACT_INITIAL_TENDERS]" mode="R519">
		<xsl:variable name="ele" select="concat(local-name(.//*[matches(local-name(),'^PT_')]),' and RIGHT_CONTRACT_INITIAL_TENDERS')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R519'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04'][.//ted:NOTICE[@*='PRI_ONLY' or @*='PER_ONLY'] and .//ted:EAUCTION_USED]" mode="R520R521">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and EAUCTION_USED')"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE[@*='PRI_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R520'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE[@*='PER_ONLY']">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R521'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F24' or @FORM='F25'][.//ted:TYPE_CONTRACT/@*='SERVICES' and .//*[matches(local-name(),'CONTRACT_COVERED_GPA')]]" mode="R522">
		<xsl:variable name="ele" select="concat('TYPE_CONTRACT[@CTYPE=', .//ted:TYPE_CONTRACT/@CTYPE,'] and ',local-name(.//ted:*[matches(local-name(),'CONTRACT_COVERED_GPA')]),'[@CTYPE=WORKS]')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R522'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F24' or @FORM='F25'][.//ted:TYPE_CONTRACT/@*='WORKS' and not(.//*[matches(local-name(),'CONTRACT_COVERED_GPA')])]" mode="R523">
		<xsl:variable name="ele" select="concat('TYPE_CONTRACT[@CTYPE=', .//ted:TYPE_CONTRACT/@CTYPE,'] and missing (NO_)CONTRACT_COVERED_GPA[@CTYPE=WORKS]')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R523'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][.//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION'] and .//ted:URL_NATIONAL_PROCEDURE]" mode="R524">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and URL_NATIONAL_PROCEDURE')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R524'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][.//ted:NOTICE[@*='QSU_ONLY' or @*='QSU_CALL_COMPETITION']]//ted:MAIN_FEATURES_AWARD" mode="R525">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R525'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][.//ted:NOTICE[@*='PRI']]//ted:MAIN_FEATURES_AWARD" mode="R526">
		<xsl:choose>
			<xsl:when test="not(descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')])"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R526'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_RECEIPT_TENDERS|ted:LANGUAGES|ted:DATE_AWARD_SCHEDULED" mode="R527R528">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM!='F01' and @FORM!='F04']"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*!='PRI_ONLY' and @*!='PER_ONLY']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', ancestor::*[@FORM]//ted:NOTICE/@*,' and ',local-name(.))"/>
				<xsl:choose>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R527'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PER_ONLY']">
						<xsl:call-template name="msg">
							<xsl:with-param name="rule" select="'R528'"/>
							<xsl:with-param name="content" select="$ele"/>
						</xsl:call-template>
					</xsl:when>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][.//ted:NOTICE[@*='PRI'] and .//ted:NOTICE_NUMBER_OJ]" mode="R529">
		<xsl:variable name="ele" select="'NOTICE/@TYPE=PRI and NOTICE_NUMBER_OJ'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R529'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][.//ted:DATE_RECEIPT_TENDERS]" mode="R530R531R532R533">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and DATE_RECEIPT_TENDERS')"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE/@*='PRI_REDUCING_TIME_LIMITS'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R530'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*='AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R531'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*[matches(.,'QSU')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R532'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*='CONCESSION_AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R533'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21' or @FORM='F22'][not(.//ted:DATE_RECEIPT_TENDERS)]//ted:NOTICE[@*[matches(.,'P.._CALL_|^CONTRACT')]] " mode="R534">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', @*,' and missing DATE_RECEIPT_TENDERS')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R534'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][not(.//ted:DATE_RECEIPT_TENDERS) and .//ted:NOTICE[@*='PRI']]" mode="R535">
		<xsl:variable name="ele" select="'NOTICE/@TYPE=PRI and missing DATE_RECEIPT_TENDERS'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R535'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05' or @FORM='F12'][.//ted:DATE_DISPATCH_INVITATIONS and .//ted:PT_OPEN]" mode="R536R537">
		<xsl:variable name="ele" select="'PT_OPEN and DATE_DISPATCH_INVITATIONS'"/>
		<xsl:choose>
			<xsl:when test="@FORM='F12'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R537'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R536'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM][.//ted:NOTICE and .//ted:LANGUAGES]" mode="R538R539R540R541">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', .//ted:NOTICE/@*,' and LANGUAGES')"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE/@*[matches(.,'REDUCING_TIME_LIMITS')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R538'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*='AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R539'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="@FORM!='F07' and .//ted:NOTICE/@*[matches(.,'QSU')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R540'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*='CONCESSION_AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R541'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F01' or @FORM='F04' or @FORM='F21' or @FORM='F22'][not(.//ted:LANGUAGES)]//ted:NOTICE[@*[matches(.,'P.._CALL_|^CONTRACT')]] " mode="R542">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', @*,' and missing LANGUAGES')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R542'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F23'][not(.//ted:LANGUAGES) and .//ted:NOTICE[@*='PRI']]" mode="R543">
		<xsl:variable name="ele" select="'NOTICE/@TYPE=PRI and missing LANGUAGES'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R543'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21' or @FORM='F22'][.//ted:DATE_AWARD_SCHEDULED and .//ted:NOTICE[@*[matches(.,'CONTRACT|^QSU')]]] " mode="R544R545R546">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',.//ted:NOTICE/@*,' and DATE_AWARD_SCHEDULED')"/>
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE/@*='CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R544'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*='AWARD_CONTRACT'">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R545'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test=".//ted:NOTICE/@*[matches(.,'QSU')]">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R546'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05'][.//ted:OPENING_CONDITION and not(.//ted:PT_OPEN)] " mode="R547">
		<xsl:variable name="ele" select="concat(local-name(.//*[matches(local-name(),'^PT_')]),' and OPENING_CONDITION')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R547'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F02' or @FORM='F05'][not(.//ted:OPENING_CONDITION) and .//ted:PT_OPEN] " mode="R548">
		<xsl:variable name="ele" select="'PT_OPEN and missing OPENING_CONDITION'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R548'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F03' or @FORM='F06'][not(.//ted:DPS) and .//ted:TERMINATION_DPS] " mode="R549">
		<xsl:variable name="ele" select="'TERMINATION_DPS without DPS'"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R549'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F21'][.//ted:TERMINATION_PIN and .//ted:NOTICE[@*[matches(.,'CALL|^CONTRACT')]]] " mode="R550">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',.//ted:NOTICE/@*,' and TERMINATION_PIN')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R550'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][.//ted:TERMINATION_PIN and .//ted:NOTICE[@*[matches(.,'CALL|^CONTRACT')]]] " mode="R551">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',.//ted:NOTICE/@*,' and TERMINATION_PIN')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R551'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM='F22'][.//ted:TERMINATION_PIN and .//ted:NOTICE[@*='QSU_ONLY']] " mode="R552">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=',.//ted:NOTICE/@*,' and TERMINATION_PIN')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R552'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:ACCELERATED_PROC" mode="R553">
		<xsl:choose>
			<xsl:when test="descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'ACCELERATED_PROC empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R553'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:CRITERIA_EVALUATION" mode="R554">
		<xsl:choose>
			<xsl:when test="descendant-or-self::*[matches(text()[1],'[\p{L}\p{N}]+')]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="'CRITERIA_EVALUATION empty'"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R554'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="//*[@FORM][number(replace(.//ted:DATE_RECEIPT_TENDERS/text(),'-','')) &lt;= number(replace(.//ted:DATE_DISPATCH_NOTICE/text(),'-',''))]" mode="R555">
		<xsl:choose>
			<xsl:when test=".//ted:NOTICE[@*[matches(.,'AWARD|QSU|ONLY|TIME')]]"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat('DATE_RECEIPT_TENDERS=',.//ted:DATE_RECEIPT_TENDERS/text(),', DATE_DISPATCH_NOTICE=',.//ted:DATE_DISPATCH_NOTICE/text())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R555'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:NOTICE_NUMBER_OJ[starts-with(.,'19')]" mode="R556">
		<xsl:choose>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE[@*='PRI' or @*='PRI_ONLY' or @*='PER_ONLY']"/>
			<xsl:otherwise>
				<xsl:variable name="ele" select="concat(local-name(.),'=',text())"/>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R556'"/>
					<xsl:with-param name="content" select="$ele"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_RECEIPT_TENDERS" mode="R557">
		<xsl:choose>
			<!--		<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_ONLY'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PER_ONLY'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='PRI_REDUCING_TIME_LIMITS'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='AWARD_CONTRACT'"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*[matches(.,'QSU')]"/>
			<xsl:when test="ancestor::*[@FORM]//ted:NOTICE/@*='CONCESSION_AWARD_CONTRACT'"/>-->
			<xsl:when test="not(matches(normalize-space(text()),'^20'))">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R557'"/>
					<xsl:with-param name="content" select="concat(local-name(.),'=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_OPENING_TENDERS" mode="R558">
		<xsl:choose>
			<!--<xsl:when test="ancestor::*[@FORM]//ted:PT_OPEN"/>-->
			<xsl:when test="not(matches(normalize-space(text()),'^20'))">
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R558'"/>
					<xsl:with-param name="content" select="concat(local-name(.),'=', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[not(.//ted:DATE_RECEIPT_TENDERS)]//ted:NOTICE[@*='PER_REDUCING_TIME_LIMITS']" mode="R559">
		<xsl:variable name="ele" select="concat('NOTICE/@TYPE=', @*,' and missing DATE_RECEIPT_TENDERS')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R559'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
</xsl:stylesheet>
